function DH = SchmittJac(lambda,X)

% SCHMITT1JAC Calculates jacobian function for Schmitt Trigger Circuit 1
%             (Modified Nodal Equations)

global a
global Gleak
% Leakage Vector


% Homotopy Function Used
%H = (X-a)*Gleak*(1-lambda) + equation(lambda*X);

dHdX = (1-lambda)*Gleak*eye(8) + lambda*jacobian(lambda*X);
dHdlambda = -Gleak*(X-a) + (jacobian(lambda*X)*X);

DH = [dHdlambda dHdX];

end